--
-- Структура таблицы `cabinet_categories`
--

CREATE TABLE `cabinet_categories` (
  `id` int(11) NOT NULL,
  `name` varchar(64) NOT NULL,
  `server` varchar(255) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Структура таблицы `cabinet_codes`
--

CREATE TABLE `cabinet_codes` (
  `id` int(11) NOT NULL,
  `code` varchar(255) NOT NULL,
  `summ` int(255) NOT NULL,
  `author` varchar(255) NOT NULL,
  `used` varchar(255) NOT NULL,
  `date_create` int(32) NOT NULL,
  `date_activete` int(32) NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Структура таблицы `cabinet_get_items`
--

CREATE TABLE `cabinet_get_items` (
  `id` int(11) UNSIGNED NOT NULL,
  `user` varchar(64) NOT NULL,
  `item` text NOT NULL,
  `block_name` text NOT NULL,
  `amount` int(11) NOT NULL,
  `server_name` varchar(64) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Структура таблицы `cabinet_logs`
--

CREATE TABLE `cabinet_logs` (
  `id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `price` float NOT NULL,
  `date` int(255) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Структура таблицы `cabinet_pay_logs`
--

CREATE TABLE `cabinet_pay_logs` (
  `id` int(11) NOT NULL,
  `name` varchar(40) COLLATE utf8_unicode_ci NOT NULL,
  `summ` float NOT NULL,
  `operation_id` int(11) NOT NULL,
  `signature` varchar(100) COLLATE utf8_unicode_ci NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Структура таблицы `cabinet_privilages`
--

CREATE TABLE `cabinet_privilages` (
  `id` int(11) NOT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `price` float NOT NULL,
  `server` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `enable` int(1) NOT NULL DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Структура таблицы `cabinet_products`
--

CREATE TABLE `cabinet_products` (
  `id` int(11) NOT NULL,
  `block_name` varchar(255) NOT NULL,
  `block_category` text NOT NULL,
  `block_id` varchar(255) NOT NULL,
  `block_image` text NOT NULL,
  `block_price` float NOT NULL,
  `block_discount` float NOT NULL,
  `server` varchar(255) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Структура таблицы `cabinet_servers`
--

CREATE TABLE `cabinet_servers` (
  `id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` varchar(255) NOT NULL,
  `enable` int(255) NOT NULL,
  `db_host` varchar(255) NOT NULL,
  `db_name` varchar(255) NOT NULL,
  `db_user` varchar(255) NOT NULL,
  `db_pass` varchar(255) NOT NULL,
  `db_plugin` varchar(32) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Индексы сохранённых таблиц
--

--
-- Индексы таблицы `cabinet_categories`
--
ALTER TABLE `cabinet_categories`
  ADD PRIMARY KEY (`id`);

--
-- Индексы таблицы `cabinet_codes`
--
ALTER TABLE `cabinet_codes`
  ADD PRIMARY KEY (`id`);

--
-- Индексы таблицы `cabinet_get_items`
--
ALTER TABLE `cabinet_get_items`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `id` (`id`),
  ADD KEY `id_2` (`id`);

--
-- Индексы таблицы `cabinet_logs`
--
ALTER TABLE `cabinet_logs`
  ADD PRIMARY KEY (`id`);

--
-- Индексы таблицы `cabinet_pay_logs`
--
ALTER TABLE `cabinet_pay_logs`
  ADD PRIMARY KEY (`id`);

--
-- Индексы таблицы `cabinet_privilages`
--
ALTER TABLE `cabinet_privilages`
  ADD PRIMARY KEY (`id`);

--
-- Индексы таблицы `cabinet_products`
--
ALTER TABLE `cabinet_products`
  ADD PRIMARY KEY (`id`);

--
-- Индексы таблицы `cabinet_servers`
--
ALTER TABLE `cabinet_servers`
  ADD PRIMARY KEY (`id`);

--
-- AUTO_INCREMENT для сохранённых таблиц
--

--
-- AUTO_INCREMENT для таблицы `cabinet_categories`
--
ALTER TABLE `cabinet_categories`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT для таблицы `cabinet_codes`
--
ALTER TABLE `cabinet_codes`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT для таблицы `cabinet_get_items`
--
ALTER TABLE `cabinet_get_items`
  MODIFY `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT для таблицы `cabinet_logs`
--
ALTER TABLE `cabinet_logs`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT для таблицы `cabinet_pay_logs`
--
ALTER TABLE `cabinet_pay_logs`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT для таблицы `cabinet_privilages`
--
ALTER TABLE `cabinet_privilages`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT для таблицы `cabinet_products`
--
ALTER TABLE `cabinet_products`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT для таблицы `cabinet_servers`
--
ALTER TABLE `cabinet_servers`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
COMMIT;

ALTER TABLE `dle_users` 
ADD `balance` FLOAT NOT NULL DEFAULT '0' AFTER `name`,
ADD `hd_skin` TINYINT(1) NOT NULL DEFAULT '0' AFTER `balance`,
ADD `hd_cloak` TINYINT(1) NOT NULL DEFAULT '0' AFTER `hd_skin`;