feather.replace();

function notif_success(content) {
  var notif_id = getRandomInt(1, 9999999);
  $('#notifications-list').append('<div class="cabinet-notif__item  notification' + notif_id + '"> <img src="/cabinet/templates/default/assets/images/notification/success.png" class="cabinet-notif__icon"> <div class="cabinet-notif__desc">' + content + '</div> </div>')
  setTimeout(function() {
    $('.notification' + notif_id).fadeOut(500, function() {
      $('.notification' + notif_id).remove();
    });
  }, 5000);
}

function notif_error(content) {
  var notif_id = getRandomInt(1, 9999999);
  $('#notifications-list').append('<div class="cabinet-notif__item  notification' + notif_id + '"> <img src="/cabinet/templates/default/assets/images/notification/warning.png" class="cabinet-notif__icon"> <div class="cabinet-notif__desc">' + content + '</div> </div>')
  setTimeout(function() {
    $('.notification' + notif_id).fadeOut(500, function() {
      $('.notification' + notif_id).remove();
    });
  }, 5000);
}

function getRandomInt(min, max) {
  return Math.floor(Math.random() * (max - min)) + min;
}

function refresh_data(id) {
  $.ajax({
    type: "POST",
    url: "/cabinet/engine/handlers/handler.php",
    data: "operation=" + id,
    success: function(data) {
      var message = JSON.parse(data);
      if (message.type == "success") {
        $('#' + id).html(message.response);
        notif_success(message.text);
      }
    }
  });
}

function upload_files(type) {
  var file_data = $('#upload-'+type).prop('files')[0];
  var form_data = new FormData();
  form_data.append('upload_'+type, file_data);
  form_data.append('type', type);
  form_data.append('operation', 'uploadfiles');
  $.ajax({
    url: '/cabinet/engine/handlers/handler.php',
    dataType: 'text',
    cache: false,
    contentType: false,
    processData: false,
    data: form_data,
    type: 'post',
    success: function(data) {
      var message = JSON.parse(data);
      $('#cabinet_skin_block').attr("view-login", message.user);
      if (message.type == "success") {
        var now = Date.now();
        $('#cabinet_skin_3d canvas').remove();
        var cabinet_number_rands = getRandomInt(1, 99999999999);
        var cabinet_user = $('#cabinet_skin_block').attr('view-login');
        var skinViewer = new skinview3d.SkinViewer({
          domElement: document.getElementById('cabinet_skin_3d'),
          slim: false,
          width: 240,
          height: 280,
          skinUrl: '/cabinet/uploads/skins/' + cabinet_user + '.png?update=' + cabinet_number_rands,
          capeUrl: '/cabinet/uploads/cloaks/' + cabinet_user + '.png?update=' + cabinet_number_rands,
        });
        var control = skinview3d.createOrbitControls(skinViewer);
        control.enableRotate = true;
        control.enableZoom = false;
        control.enablePan = false;
        skinViewer.animation = new skinview3d.CompositeAnimation();
        skinViewer.animation.add(skinview3d.RotatingAnimation);
        var walk = skinViewer.animation.add(skinview3d.WalkingAnimation);
        walk.speed = 0.7;
        $('.cabinet-view img').attr("src", "/cabinet/engine/libs/skins/view.php?show=body&cloak=hd&file_name=" + message.user + "&" + now);
        notif_success(message.text);
      }
      if (message.type == "error") notif_error(message.text);
    }
  });
}

function discard_pass() {
  var serialize = $('#discard_pass').serialize();
  $.ajax({
    type: 'POST',
    url: '/cabinet/engine/handlers/handler.php',
    data: 'operation=discard_pass&' + serialize,
    success: function(data) {
      var message = JSON.parse(data);
      if (message.type == "error") notif_error(message.text);
      if (message.type == "success") {
        notif_success(message.text);
        document.location.href = "/?action=logout";
      }
    }
  });
}

function create_gift() {
  var serialize = $('#create_gift').serialize();
  $.ajax({
    type: 'POST',
    url: '/cabinet/engine/handlers/handler.php',
    data: 'operation=create_gift&' + serialize,
    success: function(data) {
      var message = JSON.parse(data);
      if (message.type == "error") notif_error(message.text);
      if (message.type == "success") {
        $('#create_gift')[0].reset();
        notif_success(message.text);
      }
    }
  });
}

function activate_gift( code ) {
  $.ajax({
    type: 'POST',
    url: '/cabinet/engine/handlers/handler.php',
    data: 'operation=activate_gift&code=' + code,
    success: function(data) {
      var message = JSON.parse(data);
      if (message.type == "error") notif_error(message.text);
      if (message.type == "success") {
        $('#activate_code')[0].reset();
        notif_success(message.text);
      }
    }
  });
}

function view_gifts( type ) {
  $.ajax({
    type: 'POST',
    url: '/cabinet/engine/handlers/handler.php',
    data: 'operation=view_gifts&type=' + type,
    success: function(data) {
      var message = JSON.parse(data);
      if (message.type == "error") notif_error(message.text);
      if (message.type == "success") {
        $('#giftCodeModal .modal-header h5').html(message.modal_title);
        $('#giftCodeModal .modal-body').html(message.modal_content);
        $('#giftCodeModal').modal('show');
      }
    }
  });
}

function buy_opp(opp, e) {
  $.ajax({
    type: 'POST',
    url: '/cabinet/engine/handlers/handler.php',
    data: 'operation=buy_opp&opp=' + opp,
    success: function(data) {
      var message = JSON.parse(data);
      if (message.type == "error") notif_error(message.text);
      if (message.type == "success") {
        notif_success(message.text);
        $('.cabinet-opp-item_' + opp).parent().remove();
      }
    }
  });
}

function view_priducts(name, page) {
  $('.server-active').removeClass('server-active');
  $('#server-view-' + name).addClass('server-active');

  $.ajax({
    type: "POST",
    url: "/cabinet/engine/handlers/handler.php",
    data: "operation=view_products&server=" + name + '&page=' + page,
    success: function(data) {
      var message = JSON.parse(data);
      if (message.type == "success") {
        $('#shop-category').html(message.category);
        $('#shop-items-list .container-items .row').html(message.response);
        $('.cabinet-pagination').html(message.pagination);
      }
    }
  });
}

function buy_privilage_modal(server, name, id) {
  $('#privilage_name').html(name);
  $('#privilage_server').val(server);
  $('#privilage_id').val(id);
  $('#buyPrivilageModal').modal('show');
}

function buy_privilage(form, elm) {
  $.ajax({
    type: "POST",
    url: "/cabinet/engine/handlers/handler.php",
    data: new FormData($('#'+form)[0]),
    cache: false,
    contentType: false,
    processData: false,
    success: function(resp) {
      var message = JSON.parse(resp);
      if (message.type == "error") notif_error(message.text);
      if (message.type == "success") {
        notif_success(message.text);
        $('#buyPrivilageModal').modal('hide');
      }
    }
  });
  return false;
}

function search_product(page) {

  var data = $('#search-form_data').serialize();
  var server = $('.server-active').attr('id');

  $.ajax({
    type: "POST",
    url: "/cabinet/engine/handlers/handler.php",
    data: "operation=search_product&server=" + server + "&" + data + "&page=" + page,
    success: function(data) {
      var message = JSON.parse(data);
      if (message.type == "success") {
        $('#shop-items-list .container-items .row').html(message.response);
        $('.cabinet-pagination').html(message.pagination);
      }else {
        notif_error(message.text);
      }
    }
  });
}

function generate_buy_form(id) {
  $.ajax({
    type: "POST",
    url: "/cabinet/engine/handlers/handler.php",
    data: "operation=generate_buy_form&id=" + id,
    success: function(data) {
      var message = JSON.parse(data);
      if (message.type == "success") {
        $('#buyProductModal .modal-body').html(message.response);
      }
    }
  });

  $('#buyProductModal').modal('show');

}

function buy_product(id) {
  var data = $('#buy_product_form').serialize();
  $.ajax({
    type: "POST",
    url: "/cabinet/engine/handlers/handler.php",
    data: "operation=buy_product&id=" + id + "&" + data,
    success: function(data) {
      var message = JSON.parse(data);
      if (message.type == "error") notif_error(message.text);
      if (message.type == "success") {
        $('#buyProductModal').modal('hide');
        notif_success(message.text);
      }
    }
  });

}

function func_balance(form, elm)
{
  $.ajax({
    type: "POST",
    url: "/cabinet/engine/handlers/handler.php",
    data: new FormData($('#'+form)[0]),
    cache: false,
    contentType: false,
    processData: false,
    success: function(resp) {
      var message = JSON.parse(resp);
      if (message.type == "error") notif_error(message.text);
      if (message.type == "success") {
        notif_success(message.text);
        setTimeout(function(){
            window.location.href = message.link;
        }, 2000);
      }
    }
  });
  return false;
}

$('.button_3d_view').on('click', function() {
  $('.skin-3d-view').toggleClass('d-none');
  $('.button_3d_view').toggleClass('button_3d_view__active');
});

$('.category_list-item').on('click', function() {
  $(this).toggleClass('label-active');
});

var cabinet_number_rands = getRandomInt(1, 9999999);
var cabinet_user = $('#cabinet_skin_block').attr('view-login');
var skinViewer = new skinview3d.SkinViewer({
  domElement: document.getElementById('cabinet_skin_3d'),
  slim: false,
  width: 240,
  height: 280,
  skinUrl: '/cabinet/uploads/skins/' + cabinet_user + '.png?update=' + cabinet_number_rands,
  capeUrl: '/cabinet/uploads/cloaks/' + cabinet_user + '.png?update=' + cabinet_number_rands,
});
var control = skinview3d.createOrbitControls(skinViewer);
control.enableRotate = true;
control.enableZoom = false;
control.enablePan = false;
skinViewer.animation = new skinview3d.CompositeAnimation();
skinViewer.animation.add(skinview3d.RotatingAnimation);
var walk = skinViewer.animation.add(skinview3d.WalkingAnimation);
walk.speed = 0.7;
