-- Правки в таблице с пользоватлями dle_users
ALTER TABLE `dle_users`
  ADD `balance` float NOT NULL AFTER `name`,
  ADD `upload_hd_skin` int(1) NOT NULL DEFAULT '0' AFTER `balance`,
  ADD `upload_cloak` int(1) NOT NULL DEFAULT '0' AFTER `upload_hd_skin`,
  ADD `upload_hd_cloak` int(1) NOT NULL DEFAULT '0' AFTER `upload_cloak`;

-- Создание таблицы с кодами
CREATE TABLE `cabinet_codes` (
  `id` INT(11) NOT NULL AUTO_INCREMENT ,
  `code` VARCHAR(255) NOT NULL ,
  `author` VARCHAR(255) NOT NULL ,
  `used` VARCHAR(255) NOT NULL ,
  `date_create` INT(32) NOT NULL ,
  `date_activete` INT(32) NOT NULL , PRIMARY KEY (`id`)) ENGINE = InnoDB;
  -- --------------------------------------------------------

  --
  -- Структура таблицы `cabinet_categories`
  --

  CREATE TABLE `cabinet_categories` (
    `id` int(11) NOT NULL,
    `name` varchar(64) NOT NULL,
    `server` varchar(255) NOT NULL
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8;

  -- --------------------------------------------------------

  --
  -- Структура таблицы `cabinet_get_items`
  --

  CREATE TABLE `cabinet_get_items` (
    `id` int(11) UNSIGNED NOT NULL,
    `user` varchar(64) NOT NULL,
    `item` text NOT NULL,
    `block_name` text NOT NULL,
    `amount` int(11) NOT NULL,
    `server_name` varchar(64) NOT NULL
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8;

  -- --------------------------------------------------------

  --
  -- Структура таблицы `cabinet_logs`
  --

  CREATE TABLE `cabinet_logs` (
    `id` int(11) NOT NULL,
    `name` varchar(255) NOT NULL,
    `description` text NOT NULL,
    `price` float NOT NULL,
    `date` int(255) NOT NULL
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8;

  -- --------------------------------------------------------

  --
  -- Структура таблицы `cabinet_products`
  --

  CREATE TABLE `cabinet_products` (
    `id` int(11) NOT NULL,
    `block_name` varchar(255) NOT NULL,
    `block_category` text NOT NULL,
    `block_id` varchar(255) NOT NULL,
    `block_image` text NOT NULL,
    `block_price` float NOT NULL,
    `block_discount` float NOT NULL,
    `server` varchar(255) NOT NULL
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8;

  -- --------------------------------------------------------

  --
  -- Структура таблицы `cabinet_servers`
  --

  CREATE TABLE `cabinet_servers` (
    `id` int(11) NOT NULL,
    `name` varchar(255) NOT NULL,
    `description` varchar(255) NOT NULL,
    `enable` int(255) NOT NULL,
    `rcon_ip` varchar(255) NOT NULL,
    `rcon_port` varchar(255) NOT NULL,
    `rcon_pass` varchar(255) NOT NULL
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8;

  --
  -- Индексы сохранённых таблиц
  --

  --
  -- Индексы таблицы `cabinet_categories`
  --
  ALTER TABLE `cabinet_categories`
    ADD PRIMARY KEY (`id`);

  --
  -- Индексы таблицы `cabinet_get_items`
  --
  ALTER TABLE `cabinet_get_items`
    ADD PRIMARY KEY (`id`),
    ADD UNIQUE KEY `id` (`id`),
    ADD KEY `id_2` (`id`);

  --
  -- Индексы таблицы `cabinet_logs`
  --
  ALTER TABLE `cabinet_logs`
    ADD PRIMARY KEY (`id`);

  --
  -- Индексы таблицы `cabinet_products`
  --
  ALTER TABLE `cabinet_products`
    ADD PRIMARY KEY (`id`);

  --
  -- Индексы таблицы `cabinet_servers`
  --
  ALTER TABLE `cabinet_servers`
    ADD PRIMARY KEY (`id`);

  --
  -- AUTO_INCREMENT для сохранённых таблиц
  --

  --
  -- AUTO_INCREMENT для таблицы `cabinet_categories`
  --
  ALTER TABLE `cabinet_categories`
    MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
  --
  -- AUTO_INCREMENT для таблицы `cabinet_get_items`
  --
  ALTER TABLE `cabinet_get_items`
    MODIFY `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT;
  --
  -- AUTO_INCREMENT для таблицы `cabinet_logs`
  --
  ALTER TABLE `cabinet_logs`
    MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
  --
  -- AUTO_INCREMENT для таблицы `cabinet_products`
  --
  ALTER TABLE `cabinet_products`
    MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
  --
  -- AUTO_INCREMENT для таблицы `cabinet_servers`
  --
  ALTER TABLE `cabinet_servers`
    MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
