<?php

include $_SERVER['DOCUMENT_ROOT'] . '/cabinet/config.php';

function get_tpl( $template_name, $name ) {
	return file_get_contents( CAB_TEMPL . $template_name . $name );
}


if ($_POST && $member_id) {

	$post = safedArray($_POST);

	switch($post['operation'])
	{

		#	Пополнение баланса
		case 'cabinet_pay_balance':
			$summ = intval($post['pay_summ']);
			(!checkArray($post)) ? ajax_html('error', 'Все поля обязательны к заполнению, проверьте правильность введённых данных') : '';

			($summ < $cabinet_config['payment']['min_count']) ? ajax_html('error', "Сумма пополнения не может быть меньше чем {$cabinet_config['payment']['min_count']} ". pre_ending($cabinet_config['payment']['min_count'], 'рубль', 'рубля', 'рублей') ."") : '';

			(!preg_match('/^[0-9]+$/i', $summ) || $summ <= 0) ? ajax_html('error', 'Пополняемая сумма введена некорректно!') : '';

			(!in_array($post['pay_method'], ['freekassa','robokassa','interkassa','unitpay'])) ? ajax_html('error', 'Вы не выбрали систему оплаты!') : '';

			($cabinet_config['payment'][$post['pay_method']]['enable'] === false) ? ajax_html('error', 'Пополняемая система ('.$post['pay_method'].') отключена администратором!') : '';

			switch($post['pay_method'])
			{
				case 'freekassa':
					$signature = md5($cabinet_config['payment']['freekassa']['id'].":".$summ.":".$cabinet_config['payment']['freekassa']['key'].":".$member_id['name']);

					$url = [

						'm' => $cabinet_config['payment']['freekassa']['id'],
						'oa' => $summ,
						's' => $signature,
						'o' => $member_id['name']

					];

					$row = [
						'link' => "http://www.free-kassa.ru/merchant/cash.php?".http_build_query($url)
					];

					ajax_html('success', 'Перенаправление', $row);
					break;

					case 'robokassa':
						$id = time();
						$signature = md5($cabinet_config['payment']['robokassa']['login'].":".$summ.":".$id.":".$cabinet_config['payment']['robokassa']['pass1'].":shp_login=".$member_id['name']);

						$url = [

							'MerchantLogin' => $cabinet_config['payment']['robokassa']['login'],
							'OutSum' => $summ,
							'InvoiceID' => $id,
							'Description' => "Пополнение баланса на аккаунт {$member_id['name']}",
							'SignatureValue' => $signature,
							'shp_login' => $member_id['name']

						];

						$row = [
							'link' => "https://auth.robokassa.ru/Merchant/Index.aspx?".http_build_query($url)
						];

						ajax_html('success', 'Перенаправление', $row);
					break;

					case 'unitpay':
						ajax_html('error', 'Пополнение баланса через UnitPay временно недоступно.');
						break;

					case 'interkassa':
						$id = time();
						$url = [

							'ik_co_id' => $cabinet_config['payment']['interkassa']['id'],
							'ik_pm_no' => $id,
							'ik_am' => $summ,
							'ik_cur' => $cabinet_config['payment']['interkassa']['cur'],
							'ik_desc' => "Пополнение баланса на аккаунт {$member_id['name']}",
							'ik_x_login' => $member_id['name']

						];

						$row = [
							'link' => "https://sci.interkassa.com/?".http_build_query($url)
						];

						ajax_html('success', 'Перенаправление', $row);
						break;

				default: ajax_html('error', 'err!');

			}

			break;
		
		#	Обновление баланса
		case 'cabinet_ref_realbalance':
			$row = [ 'response' => $member_id['balance'], ];
			ajax_html('success', 'Баланс успешно обновлён', $row);
			break;

		#	Смена пароля
		case 'discard_pass':
			(!checkArray($post)) ? ajax_html('error', 'Все поля обязательны к заполнению, проверьте правильность введённых данных') : '';

			(!password_verify($post['old_pass'], $member_id['password'])) ? ajax_html('error', 'Введён неверный старый пароль!') : '';

			(strlen($post['new_pass']) < 3 || strlen($post['new_pass']) > 16) ? ajax_html('error', 'Длина нового пароля должна быть не менее 3 и не более 16 символов!') : '';

			($post['new_pass'] == $post['old_pass']) ? ajax_html('error', 'Новый пароль должен отличаться от старого!') : '';

			$dle_api->change_user_password($member_id['user_id'], $post['new_pass']);
			setLogs('Смена пароля', 0);
			ajax_html('success', 'Смена пароля произошла успешно');
			break;

		#	Генерация подарочного кода
		case 'create_gift':
			$summ = intval($post['code_price']);
			if ( empty($summ) ) ajax_html('error', 'Введите сумму подарочного кода', $row);
			if ( $summ < $cabinet_config['gift']['min_count'] ) ajax_html('error', "Сумма подарочного кода не может быть меньше {$cabinet_config['gift']['min_count']} рубля", $row);
			if ( $member_id['balance'] < $summ ) ajax_html('error', 'На вашем счёте недостаточно средств', $row);
			$code = create_gift($cabinet_config['gift']['template']);
			$db->query("UPDATE `dle_users` SET `balance` = `balance` - {$summ} WHERE `name` = '{$member_id['name']}'");
			$db->query("INSERT INTO `cabinet_codes` (`code`, `summ`, `author`, `used`, `date_create`, `date_activete`) VALUES ('{$code}', '{$summ}', '{$member_id['name']}', '', '". time() ."', '')");
			setLogs('Создание gift-кода', $summ);
			ajax_html('success', "Код на {$summ} ". pre_ending($summ, 'рубль', 'рубля', 'рублей') ." создан", $row);
			break;

		case 'view_gifts':
			switch($post['type']) {
				case 'list':
					$codes_list = $db->super_query("SELECT * FROM `cabinet_codes` WHERE `author` = '{$member_id['name']}' AND `enabled` = 0", TRUE);
					foreach ($codes_list as $key => $value) {
						$date = date("d.m.Y в H:i", $value['date_create']);
						$list .= <<<HTML
							<tr>
								<td>{$value['code']}</td>
								<td>{$value['summ']}</td>
								<td>{$date}</td>
							</tr>
HTML;
					}


					$table = get_tpl( $cabinet_config['template'], '/blocks/gift_codes_table.tpl');
					$table = str_replace("{codes-list}", $list, $table);
					$row = [
						'modal_title' => 'Список gift-кодов',
						'modal_content' => $table,
					];
					ajax_html('success', 'Генерация окна', $row);
					break;

				case 'activate':
					$form = get_tpl( $cabinet_config['template'], '/blocks/gift_code_form.tpl');
					$row = [
						'modal_title' => 'Активация gift-кода',
						'modal_content' => $form,
					];
					ajax_html('success', 'Генерация окна', $row);
					break;

				case 'create':
					$form = get_tpl( $cabinet_config['template'], '/blocks/gift_code_create.tpl');
					$row = [
						'modal_title' => 'Создание gift-кода',
						'modal_content' => $form,
					];
					ajax_html('success', 'Генерация окна', $row);
					break;
			}
			break;

		case 'activate_gift':
			if ( empty($post['code']) ) ajax_html('error', 'Вы не ввели gift-код');
			$sql = $db->super_query("SELECT `id`, `summ` FROM `cabinet_codes` WHERE `code` = '{$post['code']}' AND `enabled` = 0");
			if ( !$sql ) ajax_html('error', 'Данного gift-кода не существует, либо он был активирован ранее');

			$db->query("UPDATE `cabinet_codes` SET `used` = '{$member_id['name']}', `date_activete` = '". time() ."', `enabled` = '1' WHERE `id` = '{$sql['id']}'");
			$db->query("UPDATE `dle_users` SET `balance` = `balance` + '{$sql['summ']}' WHERE `name` = '{$member_id['name']}'");
			ajax_html('success', "Подарочный код успешно активирован, на ваш счёт зачислено {$sql['summ']} ". pre_ending($sql['summ'], 'рубль', 'рубля', 'рублей'));
			break;

		#	Получение списка предметов
		case 'view_products':
			$page = intval($_POST['page']);
			$start_product = ($page - 1) * $cabinet_config['shop']['count_list'];
			$server = strip_data($db->safesql($_POST['server']));

			$products_list = $db->super_query("SELECT * FROM `cabinet_products` WHERE `server` LIKE '{$server}' OR `server` = '0' LIMIT {$start_product}, {$cabinet_config['shop']['count_list']}", TRUE);
			$categories_list = $db->super_query("SELECT * FROM `cabinet_categories` WHERE `id` = '{$server}' OR `server` = 'all' ", TRUE);
			$privilages_list = $db->super_query("SELECT `id`, `name`, `price`, `server` FROM `cabinet_privilages` WHERE (`server` REGEXP '{$server}' OR `server` REGEXP 0) AND `enable` = 1 ORDER BY `price` ASC", TRUE);
			foreach ($categories_list as $key => $value) {
				$categories .= "<option value=\"{$value['id']}\">{$value['name']}</option>";
			}
			foreach ($privilages_list as $key => $value) {
				$privilages_lists .= get_tpl( $cabinet_config['template'], '/shop/privilage_block.tpl');
				$privilages_lists = str_replace("{name}", $value['name'], $privilages_lists);
				$privilages_lists = str_replace("{price}", $value['price'], $privilages_lists);
				$privilages_lists = str_replace("{server}", $value['server'], $privilages_lists);
				$privilages_lists = str_replace("{id}", $value['id'], $privilages_lists);
			}

			$priviilages .= get_tpl( $cabinet_config['template'], '/shop/privilages_list.tpl');
			$list .= str_replace("{privilages-list}", $privilages_lists, $priviilages);

			$list .= "<div class=\"container container-items\"><div class=\"row\">";
			foreach ($products_list as $key => $value) {
				$card = get_tpl( $cabinet_config['template'], '/shop/card.tpl');
				$card = str_replace("{product-id}", $value['id'], $card);
				$card = str_replace("{product-image}", $value['block_image'], $card);
				$card = str_replace("{product-name}", $value['block_name'], $card);
				$card = str_replace("{product-price}", $value['block_price'], $card);
				$list .= $card;
			}
			$list .= "</div></div>";

			$pagination = $db->super_query("SELECT COUNT(*) FROM `cabinet_products` WHERE `server` = '{$server}' OR `server` = '0'");
			$pagination_all = intval($pagination['COUNT(*)']);
			$pagination_count = ceil($pagination_all / $cabinet_config['shop']['count_list']);

			$list .= "<div class=\"col-12\"><div class=\"cabinet-pagination\">";
			for ($i=1; $i <= $pagination_count; $i++) {

				if ($i == $page) {
					$list .= <<<HTML
					<button type="button" name="button" class="cabinet-pagination__item pagination-active" onclick="view_priducts('{$_POST['server']}', {$i});">{$i}</button>
HTML;
				}else{
				$list .= <<<HTML
					<button type="button" name="button" class="cabinet-pagination__item" onclick="view_priducts('{$_POST['server']}', {$i});">{$i}</button>
HTML;
}
			}
			$list .= "</div>";

			$row = [
				'category' => $categories,
				'response' => $list,
			];
			ajax_html('success', 'Предметы с сервера успешно получены', $row);
			break;

		#	Покупка возможностей
		case 'buy_opp':
			($member_id['balance'] < $cabinet_config['shop'][$post['opp']]) ? ajax_html('error', 'На вашем счету недостаточно средств') : '';

			(!in_array($post['opp'], ['hd_skin', 'hd_cloak'])) ? ajax_html('error', 'Неверные параметры, операция не может быть выполнена') : '';

			$db->query("UPDATE `dle_users` SET `{$post['opp']}`='1', `balance`=`balance`-{$cabinet_config['shop'][$post['opp']]} WHERE `name`='{$member_id['name']}'");
			setLogs('Покупка возможности на загрузку скина/плаща', $cabinet_config['shop'][$post['opp']]);
			ajax_html('success', 'Покупка возможности произошла успешно!');
			break;

		#	Покупка привилегий
		case 'buy_privilage':
			$id = intval($post['privilage_id']);
			$month = intval($post['privilage_month']);
			$month_end = pre_ending($month, 'месяц', 'месяца', 'месяцев');

			$group = $db->super_query("SELECT * FROM `cabinet_privilages` WHERE `id`='{$id}'");
			$server = $db->super_query("SELECT * FROM `cabinet_servers` WHERE `id`='{$group['server']}'");

			(!checkArray($post) || !$month) ? ajax_html('error', 'Все поля обязательны к заполнению, проверьте правильность введённых данных') : '';

			($month < 1 || $month > 12) ? ajax_html('error', 'Фатальная ошибка, неверные данные! #1') : '';

			(!$server || $server['enable'] == 0) ? ajax_html('error', 'Фатальная ошибка, сервер не найден либо отключён администратором!') : '';

			(!$group || $group['enable'] == 0) ? ajax_html('error', 'Фатальная ошибка, привилегия не найдена либо отключена администратором!') : '';

			switch($server['db_plugin'])
			{
				case 'lp':
					$db_lp = new db();
					$db_lp->connect($server['db_user'],$server['db_pass'],$server['db_name'],$server['db_host'],1);

					$player = $db_lp->super_query("SELECT * FROM `luckperms_players` WHERE `username`='{$member_id['name']}'");

					(!$player) ? ajax_html('error', 'Фатальная ошибка, необходимо зайти на сервер!') : '';

					$group_lower = strtolower($group['name']);
					$server_lower = strtolower($server['name']);

					$buydate = $month*30;
					$startTime = time();
					$update = ($buydate * 86400);
					$group_price = $group['price']*$month;
					$expires = $startTime + ($buydate * 86400);

					$permission = $db_lp->super_query("SELECT * FROM `luckperms_user_permissions` WHERE `uuid`='{$player['uuid']}' AND `permission`='group.{$group_lower}'");

					if($cabinet_config['shop']['extend_privilage'] == true && $permission['expiry'] >= $startTime)
					{
						($member_id['balance'] < $group_price) ? ajax_html('error', 'Недостаточно средств для продления данной привилегии!') : ''; 
						$db_lp->query("UPDATE `luckperms_user_permissions` SET `expiry`=`expiry`+{$update} WHERE `uuid`='{$player['uuid']}' AND `permission`='group.{$group_lower}'");
						$db->query("UPDATE `dle_users` SET `balance`=`balance`-{$group_price} WHERE `name`='{$member_id['name']}'");
						setLogs("Продление привилегии ({$group_lower}) на {$month} {$month_end} ({$server['name']})", $group_price);
						ajax_html('success', "Вы успешно продлили {$group_lower} еще на {$month} {$month_end}!");
					}

					($permission) ? ajax_html('error', "Ошибка, у вас уже приобретена группа {$group_lower}") : '';

					($member_id['balance'] < $group_price) ? ajax_html('error', 'Недостаточно средств для покупки данной привилегии!') : '';

					$db_lp->query("INSERT INTO `luckperms_user_permissions` VALUES (NULL, '{$player['uuid']}', 'group.{$group_lower}', '1', '{$server_lower}', 'global', '{$expires}', '{}')");
					$db->query("UPDATE `dle_users` SET `balance`=`balance`-{$group_price} WHERE `name`='{$member_id['name']}'");
					setLogs("Приобретение привилегии ({$group_lower}) на {$month} {$month_end} ({$server['name']})", $group_price);
					ajax_html('success', "Вы успешно приобрели {$group_lower} на {$month} {$month_end}!");
					break;

				case 'pex':
					ajax_html('success', 'PEX');
					break;
				
				default: ajax_html('error', 'Фатальная ошибка, неверные данные! #2');
			}
		break;

		#	Получение списка предметов из поиска
		case 'search_product':
			$server = strip_data($db->safesql(substr($_POST['server'], 12)));
			$string = strip_data($db->safesql($_POST['shop-query']));
			$category = strip_data($db->safesql($_POST['shop-category']));

			if (empty($string)) {
				// $products_list = $db->super_query("SELECT * FROM `cabinet_products` WHERE `block_name` REGEXP '{$string}' AND (`server` = '0' OR `server` = '{$server}') LIMIT {$cabinet_config['shop']['count_list']}", TRUE);
			}else {
				$products_list = $db->super_query("SELECT * FROM `cabinet_products` WHERE `block_name` REGEXP '{$string}' AND (`server` = '0' OR `server` = '{$server}') LIMIT {$cabinet_config['shop']['count_list']}", TRUE);
			}

			$list .= "<div class=\"container\"><div class=\"row\">";
			foreach ($products_list as $key => $value) {
				$card = get_tpl( $cabinet_config['template'], '/shop/card.tpl');
				$card = str_replace("{product-id}", $value['id'], $card);
				$card = str_replace("{product-image}", $value['block_image'], $card);
				$card = str_replace("{product-name}", $value['block_name'], $card);
				$card = str_replace("{product-price}", $value['block_price'], $card);
				$list .= $card;
			}

			$list .= "</div></div>";

			$row = [ 'response' => $list, ];
			ajax_html('success', 'Предметы с сервера успешно получены', $row);
			break;

		#	Генерация форма покупки предмета
		case 'generate_buy_form':
			$id = intval($post['id']);
			$product = $db->super_query("SELECT * FROM `cabinet_products` WHERE `id` = '{$id}'");

			$form = get_tpl( $cabinet_config['template'], '/shop/buy_form.tpl');
			$form = str_replace("{product-image}", $product['block_image'], $form);
			$form = str_replace("{product-name}", $product['block_name'], $form);
			$form = str_replace("{product-price}", $product['block_price'], $form);
			$form = str_replace("{product-id}", $product['id'], $form);

			$row = [ 'response' => $form, ];
			ajax_html('success', 'Предметы с сервера успешно получены', $row);
			break;

		# Добавление привилегий
		case 'addprivilage':
			(!checkArray($post)) ? ajax_html('error', 'Все поля обязательны к заполнению, проверьте правильность введённых данных') : '';

			$price = intval($post['add_privilage_price']);

			(!preg_match('/^[0-9]+$/i', $price) || $price <= 0) ? ajax_html('error', 'Пополняемая сумма введена некорректно!') : '';

			$servers = [];
			foreach($post as $key => $value) {
				if($value == "on") array_push($servers, explode('-', $key)[2]);
			}

			(!$servers) ? ajax_html('error', 'Вы не выбрали сервер!') : '';

			foreach($servers as $key => $value) {
				$db->query("INSERT INTO `cabinet_privilages` (`name`, `price`, `server`, `enable`) VALUES ('{$post['add_privilage_name']}', '{$price}', '{$value}', '1')");
			}

			ajax_html('success', "Привилегия {$post['add_privilage_name']} успешно добавлена");
			break;

		#	Добавление сервера
		case 'addserver':
			(!checkArray($post)) ? ajax_html('error', 'Все поля обязательны к заполнению, проверьте правильность введённых данных') : '';

			$check_duble = $db->super_query("SELECT * FROM `cabinet_servers` WHERE `name` LIKE '{$post['add_server_name']}'");

			($check_duble) ? ajax_html('error', 'Сервер с таким именем уже существует') : '';

			$db->query("INSERT INTO `cabinet_servers` (`name`, `description`, `enable`, `db_host`, `db_name`, `db_user`, `db_pass`, `db_plugin`) VALUES ('{$post['add_server_name']}', '{$post['add_server_desc']}', '1', '{$post['add_server_dbhost']}', '{$post['add_server_dbname']}', '{$post['add_server_dblogin']}', '{$post['add_server_dbpass']}', '{$post['add_server_plugin']}')");

			ajax_html('success', 'Сервер был успешно добавлен, рекоммендуем обновить страницу');
			break;

		#	Добавление продукта 
		case 'addproduct':
			$name = $db->safesql($_POST['add_block_name']);
			$server = $db->safesql($_POST['add_block_server']);
			$block_id = $db->safesql($_POST['add_block_id']);
			$icon = $db->safesql($_POST['add_block_icon']);
			$price = $db->safesql($_POST['add_block_price']);
			$category = [];

			foreach ($_POST as $key => $value) {
				if ($value == "on") array_push($category, substr($key, 9));
			}
			
			if (empty($category)) ajax_html('error', 'Вы не добавили ни одной категории');

			if (empty($name) || empty($block_id) || empty($icon) || empty($price) || empty($category)) ajax_html('error', 'Все поля обязательны к заполнению, проверьте правильность введённых данных');
			$category = json_encode($category);

			$db->query("INSERT INTO `cabinet_products` (`block_name`, `block_category`, `block_id`, `block_image`, `block_price`, `block_discount`, `server`) VALUES ('{$name}', '{$category}', '{$block_id}', '{$icon}', '{$price}', '0', '{$server}')");
			ajax_html('success', "Блок \"{$name}\" был успешно добавлен в магазин блоков");
			break;

		#	Покупка предмета
		case 'buy_product':
			if (empty($_POST['id'])) ajax_html('error', 'Ошибка получения информации о предмете');
			if (empty($_POST['product_amount'])) ajax_html('error','Введите количетво предметов, для приобретения');
			$id = intval($_POST['id']);
			$amount = intval($_POST['product_amount']);
			$block = $db->super_query("SELECT * FROM `cabinet_products` WHERE `id` = '{$id}'");
			$server = $db->super_query("SELECT `name` FROM `cabinet_servers` WHERE `id` = '{$block['server']}'");
			$cost = intval($block['block_price']) * $amount;
			if (intval($member_id['balance']) < $cost) ajax_html('error', 'На вашем счету недостаточно средств для покупки');
			$db->query("UPDATE `dle_users` SET `balance` = `balance` - {$cost} WHERE `name` = '{$member_id['name']}'");
			$db->query("INSERT INTO `cabinet_get_items` (`user`, `item`, `block_name`, `amount`, `server_name`) VALUES ('{$member_id['name']}', '{$block['block_id']}', '{$block['block_name']}', '{$amount}', '{$server['name']}')");
			setLogs("Покупка в магазине: {$block['block_name']}", $cost);
			ajax_html("success", "Блок \"{$block['block_name']}\" был успешно приобретён на сервер {$server['name']}");
			break;

		#	Создание категорий товаров
		case 'addcategory':
			$name = $db->safesql($_POST['add_category_name']);
			$server = [];
			foreach ($_POST as $key => $value) {
				if ($value == "on") array_push($server, substr($key, 7));
			}

			if (in_array("0", $server)) $server = array("0");

			if (!$name || !$server) ajax_html('error', 'Все поля обязательны к заполнению, проверьте правильность введённых данных');
			$server = json_encode($server);

			$db->query("INSERT INTO `cabinet_categories` (`name`, `server`) VALUES ('{$name}', '{$server}')");
			ajax_html('success', 'Категория успешно добавлена');
			break;

		case 'uploadfiles':
			(!checkArray($post)) ? ajax_html('error', 'Ошибка загрузки!') : '';

			switch($post['type'])
			{
				case 'skin':
					$upload = [

						'type' => 'skin',
						'text' => 'скина',
						'folder' => '/skins/'

					];
					break;

				case 'cloak':
					$upload = [

						'type' => 'cloak',
						'text' => 'плаща',
						'folder' => '/cloaks/'

					];
					break;

				default: ajax_html('error', 'Ошибка системы!');
			}

			$files = $_FILES['upload_'.$upload['type']];
			$tmp_name = getimagesize($files['tmp_name']);

			($files['type'] != 'image/png' || $tmp_name['mime'] != 'image/png') ? ajax_html('error', 'Выберите файл в формате .PNG!') : '';

			($files['size'] > 200000) ? ajax_html('error', 'Файл превышает размер 2МБ!') : '';

			if($member_id['hd_'.$upload['type']] == 1) {

				(!in_array($tmp_name[0], [64,128,256,512,1024]) && !in_array($tmp_name[1], [32,64,128,256,512])) ? ajax_html('error', 'Файл превышает стандартные размеры!') : '';

			} else {

				($upload['type'] == 'cloak' && $member_id['hd_cloak'] == 0) ? ajax_html('error', "Извините, но возможность загрузки {$upload['text']} для вас недоступна!") : '';

				(!in_array($tmp_name[0], [64]) && !in_array($tmp_name[1], [32])) ? ajax_html('error', "Извините, но возможность загрузки HD {$upload['text']} для вас недоступна!") : '';

			}


			(!is_uploaded_file($files['tmp_name'])) ? ajax_html('error', 'Файл не смог загрузиться, попробуйте еще раз!') : '';

			(!move_uploaded_file($files['tmp_name'], $_SERVER['DOCUMENT_ROOT'] . "/cabinet/uploads{$upload['folder']}{$member_id['name']}.png")) ? ajax_html('error', 'Файл не смог загрузиться, попробуйте еще раз!') : '';

			setLogs("Обновление {$upload['text']}", 0);

			$row = [ 'user' => $member_id['name'] ];

			ajax_html('success', "Обновление {$upload['text']} успешно!", $row);
			break;
	}

}

unset($_GET, $_POST, $_FILES);
