/*
 * Decompiled with CFR 0.152.
 */
package ru.mankrash.reclouditems.mysql;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;

public class Connector
implements Runnable {
    private static List<Connector> list = new LinkedList<Connector>();
    private String name;
    private String user;
    private String pass;
    private String url;
    private Connection connection;
    private boolean interrupted = false;
    private AtomicBoolean queryInProgress = new AtomicBoolean(false);
    private AtomicBoolean queryAddEnabled = new AtomicBoolean(true);
    private BlockingQueue<String> queryQueue = new ArrayBlockingQueue<String>(128);

    public static void shutdownAll() {
        for (Connector c : list) {
            c.shutdown();
            c.close();
            c.interrupt();
        }
    }

    public Connector(String threadName, String user, String pass, String url) {
        this.name = threadName;
        this.user = user;
        this.pass = pass;
        this.url = url;
    }

    public boolean addToQuery(String query) {
        if (this.queryAddEnabled.get()) {
            return this.queryQueue.offer(query);
        }
        throw new IllegalStateException("This connector isn't accepting queries");
    }

    public boolean addToQuery(String query, Object ... args) {
        return this.addToQuery(String.format(query, args));
    }

    @Override
    public void run() {
        try {
            while (!this.interrupted) {
                this.queryInProgress.set(true);
                String query = this.queryQueue.take();
                this.query(query);
                this.queryInProgress.set(false);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public String getName() {
        return this.name;
    }

    public void interrupt() {
        this.interrupted = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean shutdown() {
        this.queryAddEnabled.set(false);
        Class<Connector> clazz = Connector.class;
        synchronized (Connector.class) {
            while (true) {
                if (this.queryQueue.isEmpty()) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return true;
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private boolean checkDriver() {
        try {
            Class.forName("com.mysql.jdbc.Driver");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public boolean checkConnection() {
        return this.open() != null;
    }

    public Connection open() {
        if (!this.checkDriver()) {
            return null;
        }
        try {
            if (this.connection == null) {
                return DriverManager.getConnection(this.url, this.user, this.pass);
            }
            if (this.connection.isValid(0)) {
                return this.connection;
            }
            return DriverManager.getConnection(this.url, this.user, this.pass);
        }
        catch (SQLException e) {
            return null;
        }
    }

    public boolean close() {
        this.connection = this.open();
        try {
            if (this.connection != null) {
                this.connection.close();
                this.connection = null;
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public synchronized ResultSet query(String query, Object ... args) {
        return this.query(String.format(query, args));
    }

    public synchronized ResultSet query(String query) {
        Statement statement = null;
        ResultSet result = null;
        this.queryInProgress.set(true);
        try {
            this.connection = this.open();
            statement = this.connection.createStatement();
            if (this.getStatement(query).equals((Object)Statements.SELECT)) {
                result = statement.executeQuery(query);
                this.queryInProgress.set(false);
                return result;
            }
            if (this.getStatement(query).equals((Object)Statements.INSERT)) {
                statement.executeUpdate(query);
                this.queryInProgress.set(false);
                return result;
            }
            statement.executeUpdate(query);
            this.queryInProgress.set(false);
            return result;
        }
        catch (SQLException e) {
            e.printStackTrace();
            this.queryInProgress.set(false);
            return result;
        }
    }

    public synchronized int updateQuery(String query) {
        Connection connection = null;
        Statement statement = null;
        try {
            connection = this.open();
            statement = connection.createStatement();
            return statement.executeUpdate(query);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public synchronized PreparedStatement prepare(String query) {
        Connection connection = null;
        PreparedStatement ps = null;
        try {
            connection = this.open();
            return connection.prepareStatement(query);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return ps;
        }
    }

    public boolean createTable(String query) {
        Statement statement = null;
        try {
            this.connection = this.open();
            statement = this.connection.createStatement();
            statement.execute(query);
            return true;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return false;
        }
    }

    public boolean checkTable(String table) {
        block4: {
            try {
                this.connection = this.open();
                Statement statement = this.connection.createStatement();
                ResultSet result = statement.executeQuery("SELECT * FROM " + table);
                if (result == null) {
                    return false;
                }
            }
            catch (SQLException e) {
                if (e.getMessage().contains("exist")) {
                    return false;
                }
                if (this.query("SELECT * FROM " + table) != null) break block4;
                return true;
            }
        }
        return false;
    }

    public boolean colExists(String table, String column) {
        ResultSet result;
        block6: {
            block5: {
                try {
                    this.connection = this.open();
                    if (this.connection != null) break block5;
                    return false;
                }
                catch (SQLException e) {
                    if (e.getMessage().contains("exist")) {
                        return false;
                    }
                    e.printStackTrace();
                    return false;
                }
            }
            DatabaseMetaData metadata = this.connection.getMetaData();
            result = metadata.getColumns(null, null, table, column);
            if (result != null) break block6;
            return false;
        }
        result.next();
        return true;
    }

    protected Statements getStatement(String query) {
        String trimmedQuery = query.trim();
        if (trimmedQuery.substring(0, 6).equalsIgnoreCase("SELECT")) {
            return Statements.SELECT;
        }
        if (trimmedQuery.substring(0, 6).equalsIgnoreCase("INSERT")) {
            return Statements.INSERT;
        }
        if (trimmedQuery.substring(0, 6).equalsIgnoreCase("UPDATE")) {
            return Statements.UPDATE;
        }
        if (trimmedQuery.substring(0, 6).equalsIgnoreCase("DELETE")) {
            return Statements.DELETE;
        }
        if (trimmedQuery.substring(0, 6).equalsIgnoreCase("CREATE")) {
            return Statements.CREATE;
        }
        if (trimmedQuery.substring(0, 5).equalsIgnoreCase("ALTER")) {
            return Statements.ALTER;
        }
        if (trimmedQuery.substring(0, 4).equalsIgnoreCase("DROP")) {
            return Statements.DROP;
        }
        if (trimmedQuery.substring(0, 8).equalsIgnoreCase("TRUNCATE")) {
            return Statements.TRUNCATE;
        }
        if (trimmedQuery.substring(0, 6).equalsIgnoreCase("RENAME")) {
            return Statements.RENAME;
        }
        if (trimmedQuery.substring(0, 2).equalsIgnoreCase("DO")) {
            return Statements.DO;
        }
        if (trimmedQuery.substring(0, 7).equalsIgnoreCase("REPLACE")) {
            return Statements.REPLACE;
        }
        if (trimmedQuery.substring(0, 4).equalsIgnoreCase("LOAD")) {
            return Statements.LOAD;
        }
        if (trimmedQuery.substring(0, 7).equalsIgnoreCase("HANDLER")) {
            return Statements.HANDLER;
        }
        if (trimmedQuery.substring(0, 4).equalsIgnoreCase("CALL")) {
            return Statements.CALL;
        }
        return Statements.SELECT;
    }

    protected static enum Statements {
        SELECT,
        INSERT,
        UPDATE,
        DELETE,
        DO,
        REPLACE,
        LOAD,
        HANDLER,
        CALL,
        CREATE,
        ALTER,
        DROP,
        TRUNCATE,
        RENAME;

    }
}

