/*
 * Decompiled with CFR 0.152.
 */
package ru.mankrash.reclouditems;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.math.NumberUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import ru.mankrash.reclouditems.Listeners;
import ru.mankrash.reclouditems.PlayerItems;
import ru.mankrash.reclouditems.ShopItem;
import ru.mankrash.reclouditems.UtilString;
import ru.mankrash.reclouditems.mysql.Connector;
import ru.mankrash.reclouditems.mysql.ConnectorBuilder;
import ru.mankrash.reclouditems.mysql.SQLCreate;

public class RecloudItems
extends JavaPlugin
implements CommandExecutor {
    private HashMap<String, Long> lastUse = new HashMap();
    private static RecloudItems instance;
    private static Connector connector;
    public static String server;

    public static RecloudItems getInstance() {
        return instance;
    }

    public void onEnable() {
        if (this.getConfig().getString("server") == null || this.getConfig().getString("db.host") == null || this.getConfig().getString("db.user") == null || this.getConfig().getString("db.pass") == null || this.getConfig().getString("db.database") == null || this.getConfig().getInt("autocheck") <= 0) {
            System.out.println("======================================================");
            System.out.println("======================================================");
            System.out.println("\u041f\u043b\u0430\u0433\u0438\u043d \u043d\u0435 \u0437\u0430\u043f\u0443\u0441\u0442\u0438\u043b\u0441\u044f! \u041f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u0432\u0441\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u043a\u043e\u043d\u0444\u0438\u0433\u0430!");
            System.out.println("======================================================");
            System.out.println("======================================================");
            return;
        }
        long startTime = System.currentTimeMillis();
        instance = this;
        this.saveDefaultConfig();
        server = this.getConfig().getString("server");
        connector = new ConnectorBuilder(this.getDescription().getName(), this.getConfig().getString("db.host"), this.getConfig().getString("db.user"), this.getConfig().getString("db.pass"), this.getConfig().getString("db.database")).build(true);
        new SQLCreate(connector);
        Bukkit.getPluginManager().registerEvents((Listener)new Listeners(), (Plugin)this);
        Bukkit.getScheduler().runTaskTimer((Plugin)this, new Runnable(){

            @Override
            public void run() {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (PlayerItems.get(player.getName()) != null) continue;
                    new PlayerItems(player.getName());
                }
            }
        }, (long)(this.getConfig().getInt("autocheck") * 20), (long)(this.getConfig().getInt("autocheck") * 20));
        long timeSpent = System.currentTimeMillis() - startTime;
        System.out.println("\u041f\u043b\u0430\u0433\u0438\u043d \u0437\u0430\u043f\u0443\u0441\u0442\u0438\u043b\u0441\u044f \u0437\u0430 " + timeSpent + "ms");
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (cmd.getName().equalsIgnoreCase("cart")) {
            PlayerItems playerItems;
            if (!sender.hasPermission("cart.cart")) {
                sender.sendMessage(this.getConfig().getString("messages.perm").replace('&', '\u00a7'));
                return true;
            }
            if (args.length == 0 || args.length >= 3) {
                for (String point : this.getConfig().getStringList("messages.help")) {
                    sender.sendMessage(UtilString.format(point));
                }
                return true;
            }
            ArrayList<String> playersItems = new ArrayList<String>();
            for (ShopItem itemCheck : ShopItem.getAllItems()) {
                playersItems.add(itemCheck.getPlayer().toLowerCase());
            }
            if (args.length == 1) {
                if (args[0].equalsIgnoreCase("list")) {
                    if (PlayerItems.get(sender.getName()) == null) {
                        sender.sendMessage(UtilString.format(this.getConfig().getString("messages.empty").replace("%autocheck%", String.valueOf(this.getConfig().getInt("autocheck")))));
                        return true;
                    }
                    if (!sender.hasPermission("cart.list")) {
                        sender.sendMessage(this.getConfig().getString("messages.perm").replace('&', '\u00a7'));
                        return true;
                    }
                    Player player = (Player)sender;
                    PlayerItems playerItems2 = PlayerItems.get(player.getName());
                    List<ShopItem> items = playerItems2.getItems();
                    player.sendMessage(this.getConfig().getString("messages.list").replace('&', '\u00a7'));
                    for (ShopItem shopItem : items) {
                        player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("messages.item").replace("%block_name%", shopItem.getBlockName()).replace("%id%", String.valueOf(shopItem.getId())).replace("%amount%", String.valueOf(shopItem.getItem().getAmount()))));
                    }
                }
                if (args[0].equalsIgnoreCase("all")) {
                    if (PlayerItems.get(sender.getName()) == null) {
                        sender.sendMessage(UtilString.format(this.getConfig().getString("messages.empty").replace("%autocheck%", String.valueOf(this.getConfig().getInt("autocheck")))));
                        return true;
                    }
                    if (!sender.hasPermission("cart.all")) {
                        sender.sendMessage(this.getConfig().getString("messages.perm").replace('&', '\u00a7'));
                        return true;
                    }
                    sender.sendMessage(UtilString.format(this.getConfig().getString("messages.all")));
                    playerItems = PlayerItems.get(sender.getName());
                    ArrayList items = new ArrayList();
                    items.addAll(playerItems.getItems());
                    Iterator iterator = items.iterator();
                    while (iterator.hasNext()) {
                        final ShopItem item2 = (ShopItem)iterator.next();
                        Player player = (Player)sender;
                        boolean empty = false;
                        int i = 0;
                        while (i < 36) {
                            if (player.getInventory().getItem(i) == null) {
                                empty = true;
                            }
                            ++i;
                        }
                        if (!empty) {
                            player.sendMessage(UtilString.format(this.getConfig().getString("messages.fullInventory")));
                            return true;
                        }
                        Bukkit.getScheduler().runTaskAsynchronously((Plugin)RecloudItems.getInstance(), new Runnable(){

                            @Override
                            public void run() {
                                RecloudItems.getConnector().query("DELETE FROM `cabinet_get_items` WHERE id='" + item2.getId() + "'");
                            }
                        });
                        playerItems.removeItem(item2);
                        player.getInventory().addItem(new ItemStack[]{item2.getItem()});
                    }
                    return true;
                }
                if (args[0].equalsIgnoreCase("get")) {
                    for (String point : this.getConfig().getStringList("messages.help")) {
                        sender.sendMessage(UtilString.format(point));
                    }
                    return true;
                }
                if (args[0].equalsIgnoreCase("update")) {
                    if (!sender.hasPermission("cart.update")) {
                        sender.sendMessage(this.getConfig().getString("messages.perm").replace('&', '\u00a7'));
                        return true;
                    }
                    Long intervalUse = this.getConfig().getLong("updatelimit");
                    Long now = Calendar.getInstance().getTimeInMillis() / 1000L;
                    Long was = 0L;
                    if (this.lastUse.containsKey(sender.getName())) {
                        was = this.lastUse.get(sender.getName());
                    }
                    if (now - was < intervalUse) {
                        sender.sendMessage(UtilString.format(this.getConfig().getString("messages.fastupdate").replace("%limit%", String.valueOf(intervalUse - (now - was)))));
                        return true;
                    }
                    this.lastUse.put(sender.getName(), now);
                    sender.sendMessage(UtilString.format(this.getConfig().getString("messages.update")));
                    if (PlayerItems.get(sender.getName()) != null) {
                        PlayerItems.get(sender.getName()).unload();
                        new PlayerItems(sender.getName());
                    } else {
                        new PlayerItems(sender.getName());
                    }
                    return true;
                }
            }
            if (args.length == 2 && args[0].equalsIgnoreCase("get")) {
                if (!sender.hasPermission("cart.get")) {
                    sender.sendMessage(this.getConfig().getString("messages.perm").replace('&', '\u00a7'));
                    return true;
                }
                if (PlayerItems.get(sender.getName()) == null) {
                    sender.sendMessage(UtilString.format(this.getConfig().getString("messages.empty").replace("%autocheck%", String.valueOf(this.getConfig().getInt("autocheck")))));
                    return true;
                }
                if (!NumberUtils.isNumber((String)args[1])) {
                    sender.sendMessage(UtilString.format(this.getConfig().getString("messages.number")));
                    return true;
                }
                playerItems = PlayerItems.get(sender.getName());
                int idArg = Integer.valueOf(args[1]);
                ArrayList<Integer> fullIds = new ArrayList<Integer>();
                for (ShopItem shopItem : playerItems.getItems()) {
                    fullIds.add(shopItem.getId());
                    if (idArg != shopItem.getId()) continue;
                    Player player = (Player)sender;
                    boolean empty = false;
                    int i = 0;
                    while (i < 36) {
                        if (player.getInventory().getItem(i) == null) {
                            empty = true;
                        }
                        ++i;
                    }
                    if (!empty) {
                        player.sendMessage(UtilString.format(this.getConfig().getString("messages.fullInventory")));
                        return true;
                    }
                    player.sendMessage(UtilString.format(this.getConfig().getString("messages.get").replace("%amount%", String.valueOf(shopItem.getItem().getAmount())).replace("%block_name%", shopItem.getBlockName()).replace("%id%", String.valueOf(shopItem.getId()))));
                    RecloudItems.getConnector().query("DELETE FROM `cabinet_get_items` WHERE id='" + shopItem.getId() + "'");
                    playerItems.removeItem(shopItem);
                    player.getInventory().addItem(new ItemStack[]{shopItem.getItem()});
                    return true;
                }
                if (!fullIds.contains(idArg)) {
                    sender.sendMessage(UtilString.format(this.getConfig().getString("messages.nofound")));
                    return true;
                }
                return true;
            }
        }
        return true;
    }

    public static Connector getConnector() {
        return connector;
    }
}

